<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Admin Dashboard - The ONYX</title>
    <script src="https://cdn.tailwindcss.com"></script>
    <script>
        tailwind.config = {
            darkMode: 'class',
        }
    </script>
    <style>
        .bg-accent { background: linear-gradient(to right, #22696B, #0C4C4C); }
        .text-accent { color: #22696B; }
        .hover-bg-accent:hover { background: linear-gradient(to right, #1a5456, #0a3d3d); }
        body { font-family: ui-sans-serif, system-ui, -apple-system, Segoe UI, Roboto, Helvetica, Arial; }
        .glass { background: rgba(255,255,255,0.03); border: 1px solid rgba(255,255,255,0.08); backdrop-filter: blur(8px); }
        .dark .glass { background: rgba(255,255,255,0.03); border: 1px solid rgba(255,255,255,0.08); }
        .light .glass { background: rgba(255,255,255,0.7); border: 1px solid rgba(0,0,0,0.1); }
        .sidebar { min-width: 260px; }
        .nav-link { display:block; padding:0.75rem 1rem; border-radius:0.75rem; transition: all .2s ease; }
        .dark .nav-link { color:#cfcfcf; }
        .light .nav-link { color:#4b5563; }
        .nav-link:hover, .nav-link.active { background-color: rgba(245,124,0,0.15); color:#fff; }
        .light .nav-link:hover, .light .nav-link.active { background-color: rgba(34, 105, 107, 0.1); color:#22696B; }
        .status-pill { display:inline-flex; align-items:center; gap:0.35rem; padding:0.25rem 0.75rem; border-radius:999px; font-size:0.75rem; }
    </style>
    <script>
        // Check local storage or system preference
        if (localStorage.theme === 'dark' || (!('theme' in localStorage) && window.matchMedia('(prefers-color-scheme: dark)').matches)) {
            document.documentElement.classList.add('dark');
            document.documentElement.classList.remove('light');
        } else {
            document.documentElement.classList.remove('dark');
            document.documentElement.classList.add('light');
        }

        function toggleTheme() {
            if (document.documentElement.classList.contains('dark')) {
                document.documentElement.classList.remove('dark');
                document.documentElement.classList.add('light');
                localStorage.theme = 'light';
            } else {
                document.documentElement.classList.remove('light');
                document.documentElement.classList.add('dark');
                localStorage.theme = 'dark';
            }
        }
    </script>
</head>
<body data-require-auth="true" data-require-role="admin" class="bg-gray-50 text-gray-900 dark:bg-[#0a0a0a] dark:text-white transition-colors duration-300">
    <div class="min-h-screen flex relative">
        <!-- Mobile Sidebar Overlay -->
        <div id="sidebar-overlay" class="fixed inset-0 bg-black/80 z-40 hidden lg:hidden glass" onclick="toggleSidebar()"></div>

        <!-- Sidebar -->
        <aside id="sidebar" class="sidebar bg-white dark:bg-black/90 border-r border-gray-200 dark:border-neutral-800 p-6 fixed inset-y-0 left-0 z-50 w-64 transform -translate-x-full transition-transform duration-300 lg:translate-x-0 lg:static lg:flex flex-col">
            <div class="flex items-center justify-between mb-10">
                <div class="text-2xl font-extrabold tracking-wide">
                    <img src="/images/logo.png" alt="Onyx Admin Logo" class="h-12 block dark:hidden" style="filter: invert(1);">
                    <img src="/images/logo.png" alt="Onyx Admin Logo" class="h-12 hidden dark:block">
                </div>
                <button class="lg:hidden text-gray-400 hover:text-gray-900 dark:hover:text-white" onclick="toggleSidebar()">
                    <svg xmlns="http://www.w3.org/2000/svg" class="h-6 w-6" fill="none" viewBox="0 0 24 24" stroke="currentColor">
                        <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M6 18L18 6M6 6l12 12" />
                    </svg>
                </button>
            </div>
            <nav class="space-y-1 flex-1">
                <a href="{{ route('admin.dashboard') }}" class="nav-link active">Dashboard</a>
                <a href="{{ route('admin.approvals') }}" class="nav-link">Approvals</a>

                <a href="{{ route('admin.users') }}" class="nav-link">Users</a>
        
                <a href="{{ route('admin.settings') }}" class="nav-link">Settings</a>
                <a href="#" data-auth="logout" data-redirect="/login" class="nav-link">Logout</a>
            </nav>
            <div class="mt-6 glass rounded-xl p-4 bg-gray-100 dark:bg-transparent">
                <div class="text-xs uppercase text-gray-500 dark:text-gray-400">Support</div>
                <div class="text-sm mt-1 text-gray-900 dark:text-white">infopk@meer.capital</div>
            </div>
        </aside>

        <!-- Main content -->
        <div class="flex-1 flex flex-col min-w-0">
            <header class="text-white px-4 md:px-6 py-4 flex items-center justify-between sticky top-0 z-30" style="background: linear-gradient(to right, #22696B, #0C4C4C);">
                <div class="flex items-center gap-3">
                    <button class="lg:hidden p-1 hover:bg-white/10 rounded" onclick="toggleSidebar()">
                        <svg xmlns="http://www.w3.org/2000/svg" class="h-6 w-6" fill="none" viewBox="0 0 24 24" stroke="currentColor">
                            <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M4 6h16M4 12h16M4 18h16" />
                        </svg>
                    </button>
                    <div>
                        <h1 class="text-lg md:text-xl font-semibold">Admin Control Center</h1>
                        <p class="text-xs md:text-sm text-white/80">Monitor bookings, assets, and project performance</p>
                    </div>
                </div>
                <div class="flex items-center gap-4">
                    <button onclick="toggleTheme()" class="p-2 rounded-full hover:bg-white/10 transition-colors">
                        <!-- Sun icon -->
                        <svg xmlns="http://www.w3.org/2000/svg" class="h-5 w-5 hidden dark:block" fill="none" viewBox="0 0 24 24" stroke="currentColor">
                            <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M12 3v1m0 16v1m9-9h-1M4 12H3m15.364 6.364l-.707-.707M6.343 6.343l-.707-.707m12.728 0l-.707.707M6.343 17.657l-.707.707M16 12a4 4 0 11-8 0 4 4 0 018 0z" />
                        </svg>
                        <!-- Moon icon -->
                        <svg xmlns="http://www.w3.org/2000/svg" class="h-5 w-5 block dark:hidden" fill="none" viewBox="0 0 24 24" stroke="currentColor">
                            <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M20.354 15.354A9 9 0 018.646 3.646 9.003 9.003 0 0012 21a9.003 9.003 0 008.354-5.646z" />
                        </svg>
                    </button>
                <div class="hidden md:flex items-center gap-4 text-sm">
                    <a href="{{ route('booking.form') }}" class="underline">New Booking</a>
                    <a href="{{ route('user.documents') }}" class="underline">Documents</a>
                    <a href="#" data-auth="logout" data-redirect="/login" class="underline">Logout</a>
                </div>
            </header>

            <main class="p-6 space-y-6">
                <!-- Top metrics -->
                <div id="metrics-grid" class="grid lg:grid-cols-2 md:grid-cols-2 gap-4">
                    <div class="glass rounded-xl p-5">
                        <div class="text-gray-600 dark:text-gray-400 text-sm">Total Bookings</div>
                        <div id="total-bookings" class="text-3xl font-extrabold text-accent mt-2">...</div>
                    </div>
                    <div class="glass rounded-xl p-5">
                        <div class="text-gray-600 dark:text-gray-400 text-sm">Pending Approvals</div>
                        <div id="pending-approvals" class="text-3xl font-extrabold text-accent mt-2">...</div>
                    </div>
                </div>

                <!-- Recent activity -->
                <div class="glass rounded-xl p-6">
                    <div class="flex items-center justify-between mb-4">
                        <h2 class="text-lg font-semibold">Recent Bookings</h2>
                        <a href="{{ route('admin.approvals') }}" class="text-sm text-accent">View all</a>
                    </div>
                    <div id="recent-bookings" class="space-y-4">
                        <!-- Recent bookings will be dynamically inserted here -->
                    </div>
                </div>

                <script type="module">
                    import { fetchAllBookings } from '/js/auth.js';

                    document.addEventListener('DOMContentLoaded', async () => {
                        const bookings = await fetchAllBookings();

                        // Update total bookings count
                        const totalBookingsEl = document.getElementById('total-bookings');
                        if (totalBookingsEl) {
                            totalBookingsEl.textContent = bookings.length;
                        }

                        // Update pending approvals count
                        const pendingApprovalsEl = document.getElementById('pending-approvals');
                        if (pendingApprovalsEl) {
                            const pendingCount = bookings.filter(booking => !booking.is_approved).length;
                            pendingApprovalsEl.textContent = pendingCount;
                        }

                        // Populate recent bookings
                        const recentBookingsEl = document.getElementById('recent-bookings');
                        if (recentBookingsEl) {
                            recentBookingsEl.innerHTML = ''; // Clear placeholder
                            const recent = bookings.slice(-3).reverse(); // Get last 3, newest first

                            if (recent.length === 0) {
                                recentBookingsEl.innerHTML = '<p>No recent bookings.</p>';
                            } else {
                                recent.forEach(booking => {
                                    const row = `
                                        <div class="flex items-center justify-between">
                                            <div>
                                                <div class="font-medium text-gray-900 dark:text-white">${booking.apartment_number || 'N/A'}</div>
                                                <div class="text-sm text-gray-600 dark:text-gray-400">Booked by ${booking.proposed_name || 'N/A'}</div>
                                            </div>
                                            <span class="status-pill ${booking.is_approved ? 'bg-green-500/15 text-green-600 dark:text-green-400' : 'bg-yellow-500/20 text-yellow-600 dark:text-yellow-400'}">
                                                ${booking.is_approved ? 'Approved' : 'Pending'}
                                            </span>
                                        </div>
                                    `;
                                    recentBookingsEl.insertAdjacentHTML('beforeend', row);
                                });
                            }
                        }
                    });
                </script>
            </main>
        </div>
    </div>
</body>
<script type="module" src="/js/auth.js"></script>
    <script>
        function toggleSidebar() {
            const sidebar = document.getElementById('sidebar');
            const overlay = document.getElementById('sidebar-overlay');
            
            if (sidebar.classList.contains('-translate-x-full')) {
                // Open
                sidebar.classList.remove('-translate-x-full');
                overlay.classList.remove('hidden');
            } else {
                // Close
                sidebar.classList.add('-translate-x-full');
                overlay.classList.add('hidden');
            }
        }
    </script>
</html>


