<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Admin Login - The ONYX</title>
    <script src="https://cdn.tailwindcss.com"></script>
    <link rel="preconnect" href="https://fonts.googleapis.com">
    <link rel="preconnect" href="https://fonts.gstatic.com" crossorigin>
    <link href="https://fonts.googleapis.com/css2?family=Inter:wght@400;500;600;700&display=swap" rel="stylesheet">
    <style>
        .text-accent { color: #22696B; }
        .bg-accent { background: linear-gradient(to right, #22696B, #0C4C4C); }
        .hover-bg-accent:hover { background: linear-gradient(to right, #1a5456, #0a3d3d); }
        body { 
            background-color:#070707; 
            color:#f1f1f1; 
            font-family: Inter, ui-sans-serif, system-ui, -apple-system, Segoe UI, Roboto, Helvetica, Arial;
            background-image: 
                radial-gradient(900px 500px at 120% -20%, rgba(245,124,0,0.10), transparent 60%),
                radial-gradient(900px 500px at -20% -20%, rgba(245,124,0,0.08), transparent 60%);
        }
        .glass { background: rgba(255,255,255,0.05); border: 1px solid rgba(255,255,255,0.12); backdrop-filter: blur(8px); }
        .hero-side {
            background: url('/images/onyx.png') no-repeat center center;
            background-size: cover;
        }
    </style>
</head>
<body data-require-auth="false" class="min-h-screen flex">
    <!-- Hero Side (Hidden on mobile) -->
    <div class="hidden lg:flex lg:w-1/2 hero-side relative items-end">
        <div class="absolute inset-0 bg-gradient-to-br from-black/75 to-black/30"></div>
        <div class="p-12 relative z-10 text-white">
            <h1 class="text-5xl font-bold mb-4">The ONYX Admin</h1>
            <p class="text-xl text-white/50 leading-relaxed">
                Manage bookings, monitor assets, and keep your development on track from a powerful control center.
            </p>
        </div>
    </div>

    <!-- Login Form Section -->
    <div class="w-full lg:w-1/2 flex items-center justify-center p-6">
        <div class="w-full max-w-md glass rounded-2xl p-8 shadow-2xl">
            <div class="text-center mb-6">
                <span class="inline-block px-3 py-1 rounded-full bg-neutral-900 border border-neutral-700 text-xs uppercase tracking-wider text-gray-400 mb-4">Admin Portal</span>
                <h2 class="text-3xl font-bold text-white mb-1">Secure Login</h2>
                <p class="text-accent">Authorized access only</p>
            </div>
            
            <form data-auth="login-form" data-redirect="/admin/dashboard" data-role="admin" class="space-y-6">
                <div>
                    <label for="admin-email" class="block text-sm font-medium text-gray-300 mb-2">Admin Email</label>
                    <input type="email" id="admin-email" name="email" required 
                        class="w-full bg-white/5 border border-white/10 rounded-lg px-4 py-3 text-white focus:outline-none focus:border-accent focus:ring-1 focus:ring-accent transition-colors">
                </div>
                
                <div>
                    <label for="admin-password" class="block text-sm font-medium text-gray-300 mb-2">Password</label>
                    <input type="password" id="admin-password" name="password" required 
                        class="w-full bg-white/5 border border-white/10 rounded-lg px-4 py-3 text-white focus:outline-none focus:border-accent focus:ring-1 focus:ring-accent transition-colors">
                </div>

                <div class="text-center text-red-400 text-sm hidden" data-auth-alert></div>

                <button type="submit" class="w-full bg-accent hover-bg-accent text-white font-semibold py-3 rounded-lg transition-colors shadow-lg shadow-orange-900/20">
                    Login
                </button>

                <div class="text-center mt-6 flex flex-col gap-2">
                    <a href="{{ route('password.request') }}" class="text-sm text-gray-400 hover:text-accent transition-colors">Forgot password?</a>
                </div>
            </form>
        </div>
    </div>
    <script type="module" src="/js/auth.js"></script>
</body>
</html>

