<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Dashboard - The ONYX</title>
    <script src="https://cdn.tailwindcss.com"></script>
    <script>
        tailwind.config = {
            darkMode: 'class',
        }
    </script>
    <style>
        .bg-accent { background: linear-gradient(to right, #22696B, #0C4C4C); }
        .text-accent { color: #22696B; }
        .hover-bg-accent:hover { background: linear-gradient(to right, #1a5456, #0a3d3d); }
        body { font-family: ui-sans-serif, system-ui, -apple-system, Segoe UI, Roboto, Helvetica, Arial; }
        .glass { background: rgba(255,255,255,0.03); border: 1px solid rgba(255,255,255,0.08); backdrop-filter: blur(6px); }
        .dark .glass { background: rgba(255,255,255,0.03); border: 1px solid rgba(255,255,255,0.08); }
        .light .glass { background: #ffffff; border: 1px solid #e5e7eb; box-shadow: 0 1px 3px 0 rgba(0, 0, 0, 0.1), 0 1px 2px 0 rgba(0, 0, 0, 0.06); }
        .sidebar { width: 260px; }
    </style>
    <script>
        // Check local storage or system preference
        if (localStorage.theme === 'dark' || (!('theme' in localStorage) && window.matchMedia('(prefers-color-scheme: dark)').matches)) {
            document.documentElement.classList.add('dark')
        } else {
            document.documentElement.classList.remove('dark')
        }

        function toggleTheme() {
            if (document.documentElement.classList.contains('dark')) {
                document.documentElement.classList.remove('dark');
                localStorage.theme = 'light';
            } else {
                document.documentElement.classList.add('dark');
                localStorage.theme = 'dark';
            }
        }
    </script>
</head>
<body data-require-auth="true" data-require-role="client" class="bg-gray-50 text-gray-900 dark:bg-[#0a0a0a] dark:text-white transition-colors duration-300">
    <div class="min-h-screen flex relative">
        <!-- Mobile Sidebar Overlay -->
        <div id="sidebar-overlay" class="fixed inset-0 bg-black/80 z-40 hidden md:hidden glass" onclick="toggleSidebar()"></div>

        <!-- Sidebar -->
        <aside id="sidebar" class="sidebar bg-white dark:bg-black/90 border-r border-gray-200 dark:border-neutral-800 p-6 fixed inset-y-0 left-0 z-50 w-64 transform -translate-x-full transition-transform duration-300 md:translate-x-0 md:static md:block">
            <div class="flex items-center justify-between mb-8">
                <div class="text-xl font-bold">
                    <img src="/images/logo.png" alt="Onyx Logo" class="h-12 block dark:hidden" style="filter: invert(1);">
                    <img src="/images/logo.png" alt="Onyx Logo" class="h-12 hidden dark:block">
                </div>
                <button class="md:hidden text-gray-400 hover:text-gray-900 dark:hover:text-white" onclick="toggleSidebar()">
                    <svg xmlns="http://www.w3.org/2000/svg" class="h-6 w-6" fill="none" viewBox="0 0 24 24" stroke="currentColor">
                        <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M6 18L18 6M6 6l12 12" />
                    </svg>
                </button>
            </div>
            <nav class="space-y-2">
                <a href="{{ route('dashboard') }}" class="block px-4 py-2 rounded hover:bg-gray-100 dark:hover:bg-neutral-800 bg-gray-100 dark:bg-neutral-800/50 text-gray-900 dark:text-white">Overview</a>
                <a href="{{ route('user.bookings') }}" class="block px-4 py-2 rounded hover:bg-gray-100 dark:hover:bg-neutral-800 text-gray-600 dark:text-gray-400 hover:text-gray-900 dark:hover:text-white">Bookings</a>
            </nav>
        </aside>

        <!-- Content -->
        <div class="flex-1 flex flex-col min-w-0">
            <header class="text-white px-4 md:px-6 py-4 flex items-center justify-between sticky top-0 z-30" style="background: linear-gradient(to right, #22696B, #0C4C4C);">
                <div class="flex items-center gap-3">
                    <button class="md:hidden p-1 hover:bg-white/10 rounded" onclick="toggleSidebar()">
                        <svg xmlns="http://www.w3.org/2000/svg" class="h-6 w-6" fill="none" viewBox="0 0 24 24" stroke="currentColor">
                            <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M4 6h16M4 12h16M4 18h16" />
                        </svg>
                    </button>
                    <div>
                        <h1 class="text-lg md:text-xl font-semibold">Dashboard</h1>
                        <p class="text-xs md:text-sm text-white/80">Welcome to your dashboard</p>
                    </div>
                </div>
                <div class="flex items-center gap-4">
                    <button onclick="toggleTheme()" class="p-2 rounded-full hover:bg-white/10 transition-colors">
                        <!-- Sun icon -->
                        <svg xmlns="http://www.w3.org/2000/svg" class="h-5 w-5 hidden dark:block" fill="none" viewBox="0 0 24 24" stroke="currentColor">
                            <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M12 3v1m0 16v1m9-9h-1M4 12H3m15.364 6.364l-.707-.707M6.343 6.343l-.707-.707m12.728 0l-.707.707M6.343 17.657l-.707.707M16 12a4 4 0 11-8 0 4 4 0 018 0z" />
                        </svg>
                        <!-- Moon icon -->
                        <svg xmlns="http://www.w3.org/2000/svg" class="h-5 w-5 block dark:hidden" fill="none" viewBox="0 0 24 24" stroke="currentColor">
                            <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M20.354 15.354A9 9 0 018.646 3.646 9.003 9.003 0 0012 21a9.003 9.003 0 008.354-5.646z" />
                        </svg>
                    </button>
                <div class="hidden sm:flex items-center gap-4 text-sm">
                    <a href="{{ route('booking.form') }}" class="underline">New Booking</a>
                    <a href="{{ route('user.documents') }}" class="underline">Documents</a>
                    <a href="#" data-auth="logout" data-redirect="/login" class="underline">Logout</a>
                </div>
            </header>

            <main class="p-4 md:p-6">
                <div class="grid grid-cols-1 md:grid-cols-2 gap-4 md:gap-6 mb-8">
                    <div class="glass rounded-xl p-5">
                        <div class="text-gray-600 dark:text-gray-400 text-sm">Total Bookings</div>
                        <div class="text-3xl font-extrabold text-accent mt-2" id="total-bookings-count">—</div>
                    </div>
                    <div class="glass rounded-xl p-5">
                        <div class="text-gray-600 dark:text-gray-400 text-sm">Pending Approvals</div>
                        <div class="text-3xl font-extrabold text-accent mt-2" id="pending-approvals-count">—</div>
                    </div>
                </div>

                <div class="glass rounded-xl p-6">
                    <h2 class="text-xl font-semibold mb-4 text-gray-900 dark:text-white">Quick Actions</h2>
                    <div class="flex flex-col sm:flex-row gap-3">
                        <a href="{{ route('booking.form') }}" class="px-5 py-3 rounded-full bg-accent hover-bg-accent text-white text-center">Create Booking</a>
                        <a href="{{ route('user.documents') }}" class="px-5 py-3 rounded-full border border-gray-300 dark:border-neutral-700 hover:border-gray-400 dark:hover:border-white text-gray-700 dark:text-white text-center">Check Documents</a>
                    </div>
                </div>
            </main>
        </div>
    </div>
    <script type="module" src="/js/auth.js"></script>
    <script>
        function toggleSidebar() {
            const sidebar = document.getElementById('sidebar');
            const overlay = document.getElementById('sidebar-overlay');
            
            if (sidebar.classList.contains('-translate-x-full')) {
                // Open
                sidebar.classList.remove('-translate-x-full');
                overlay.classList.remove('hidden');
            } else {
                // Close
                sidebar.classList.add('-translate-x-full');
                overlay.classList.add('hidden');
            }
        }
    </script>
    <script type="module">
        import { fetchDashboardStats } from '/js/auth.js';

        document.addEventListener('DOMContentLoaded', async () => {
            const stats = await fetchDashboardStats();
            const totalBookingsEl = document.getElementById('total-bookings-count');
            const pendingApprovalsEl = document.getElementById('pending-approvals-count');
            
            if (totalBookingsEl) totalBookingsEl.textContent = stats.totalBookings;
            if (pendingApprovalsEl) pendingApprovalsEl.textContent = stats.pendingApprovals;
        });
    </script>
</body>
</html>


