<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Booking - The ONYX</title>
    <script src="https://cdn.tailwindcss.com"></script>
    <script>
        tailwind.config = {
            darkMode: 'class',
        }
    </script>
    <link rel="preconnect" href="https://fonts.googleapis.com">
    <link rel="preconnect" href="https://fonts.gstatic.com" crossorigin>
    <link href="https://fonts.googleapis.com/css2?family=Inter:wght@400;500;600;700;800&display=swap" rel="stylesheet">
    <style>
        .text-accent { color: #22696B; }
        .bg-accent { background: linear-gradient(to right, #22696B, #0C4C4C); }
        .hover-bg-accent:hover { background: linear-gradient(to right, #1a5456, #0a3d3d); }
        body { font-family: Inter, ui-sans-serif, system-ui, -apple-system, Segoe UI, Roboto, Helvetica, Arial; }
        .glass { background: rgba(255,255,255,0.03); border: 1px solid rgba(255,255,255,0.08); backdrop-filter: blur(6px); }
        .dark .glass { background: rgba(255,255,255,0.03); border: 1px solid rgba(255,255,255,0.08); }
        .light .glass { background: rgba(255,255,255,0.7); border: 1px solid rgba(0,0,0,0.1); }
        .step-hidden { display:none; }

           .file-upload {
        position: relative;
        display: inline-block;
    }
    .file-upload-label {
        display: block;
        padding: 0.5rem 1rem;
        background: rgba(0, 0, 0, 0.4);
        border: 1px dashed #4b5563;
        border-radius: 0.375rem;
        cursor: pointer;
        text-align: center;
        transition: all 0.2s;
    }
    .light .file-upload-label {
        background: rgba(255, 255, 255, 0.5);
        border-color: #d1d5db;
        color: #4b5563;
    }
    .file-upload-label:hover {
        background: rgba(0, 0, 0, 0.6);
        border-color: #6b7280;
    }
    .light .file-upload-label:hover {
        background: rgba(255, 255, 255, 0.8);
        border-color: #9ca3af;
    }
    .file-upload-input {
        position: absolute;
        left: 0;
        top: 0;
        opacity: 0;
        width: 100%;
        height: 100%;
        cursor: pointer;
    }
    .image-preview {
        margin-top: 0.5rem;
        max-width: 100%;
        max-height: 200px;
        display: none;
        border-radius: 0.375rem;
        border: 1px solid rgba(255,255,255,0.1);
    }
    .light .image-preview {
        border-color: rgba(0,0,0,0.1);
    }
    </style>
    <script>
        // Check local storage or system preference
        if (localStorage.theme === 'dark' || (!('theme' in localStorage) && window.matchMedia('(prefers-color-scheme: dark)').matches)) {
            document.documentElement.classList.add('dark');
            document.documentElement.classList.remove('light');
        } else {
            document.documentElement.classList.remove('dark');
            document.documentElement.classList.add('light');
        }

        function toggleTheme() {
            if (document.documentElement.classList.contains('dark')) {
                document.documentElement.classList.remove('dark');
                document.documentElement.classList.add('light');
                localStorage.theme = 'light';
            } else {
                document.documentElement.classList.remove('light');
                document.documentElement.classList.add('dark');
                localStorage.theme = 'dark';
            }
        }
    </script>
</head>
<body class="bg-gray-50 text-gray-900 dark:bg-[#0a0a0a] dark:text-white transition-colors duration-300">
    <div class="min-h-screen flex relative">
        <!-- Mobile Sidebar Overlay -->
        <div id="sidebar-overlay" class="fixed inset-0 bg-black/80 z-40 hidden md:hidden glass" onclick="toggleSidebar()"></div>

        <!-- Sidebar -->
        <aside id="sidebar" class="sidebar bg-white dark:bg-black/90 border-r border-gray-200 dark:border-neutral-800 p-6 fixed inset-y-0 left-0 z-50 w-64 transform -translate-x-full transition-transform duration-300 md:translate-x-0 md:static md:block">
            <div class="flex items-center justify-between mb-8">
                <div class="text-xl font-bold">
                    <img src="/images/logo.png" alt="Onyx Logo" class="h-12 block dark:hidden">
                    <img src="/images/logo.png" alt="Onyx Logo" class="h-12 hidden dark:block">
                </div>
                <button class="md:hidden text-gray-400 hover:text-gray-900 dark:hover:text-white" onclick="toggleSidebar()">
                    <svg xmlns="http://www.w3.org/2000/svg" class="h-6 w-6" fill="none" viewBox="0 0 24 24" stroke="currentColor">
                        <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M6 18L18 6M6 6l12 12" />
                    </svg>
                </button>
            </div>
            <nav class="space-y-2">
                <a href="{{ route('dashboard') }}" class="block px-4 py-2 rounded hover:bg-gray-100 dark:hover:bg-neutral-800 text-gray-600 dark:text-gray-400 hover:text-gray-900 dark:hover:text-white">Overview</a>
                <a href="{{ route('user.bookings') }}" class="block px-4 py-2 rounded hover:bg-gray-100 dark:hover:bg-neutral-800 text-gray-600 dark:text-gray-400 hover:text-gray-900 dark:hover:text-white">Bookings</a>
                <a href="{{ route('booking.form') }}" class="block px-4 py-2 rounded hover:bg-gray-100 dark:hover:bg-neutral-800 bg-gray-100 dark:bg-neutral-800/50 text-gray-900 dark:text-white">New Booking</a>
            </nav>
        </aside>

        <!-- Content -->
        <div class="flex-1 flex flex-col min-w-0">
            <header class="text-white px-4 md:px-6 py-4 flex items-center justify-between sticky top-0 z-30" style="background: linear-gradient(to right, #22696B, #0C4C4C);">
                <div class="flex items-center gap-3">
                    <button class="md:hidden p-1 hover:bg-white/10 rounded" onclick="toggleSidebar()">
                        <svg xmlns="http://www.w3.org/2000/svg" class="h-6 w-6" fill="none" viewBox="0 0 24 24" stroke="currentColor">
                            <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M4 6h16M4 12h16M4 18h16" />
                        </svg>
                    </button>
                    <div class="font-semibold text-lg">Apartment Booking</div>
                </div>
                <div class="flex items-center gap-4">
                    <button onclick="toggleTheme()" class="p-2 rounded-full hover:bg-white/10 transition-colors">
                        <!-- Sun icon -->
                        <svg xmlns="http://www.w3.org/2000/svg" class="h-5 w-5 hidden dark:block" fill="none" viewBox="0 0 24 24" stroke="currentColor">
                            <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M12 3v1m0 16v1m9-9h-1M4 12H3m15.364 6.364l-.707-.707M6.343 6.343l-.707-.707m12.728 0l-.707.707M6.343 17.657l-.707.707M16 12a4 4 0 11-8 0 4 4 0 018 0z" />
                        </svg>
                        <!-- Moon icon -->
                        <svg xmlns="http://www.w3.org/2000/svg" class="h-5 w-5 block dark:hidden" fill="none" viewBox="0 0 24 24" stroke="currentColor">
                            <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M20.354 15.354A9 9 0 018.646 3.646 9.003 9.003 0 0012 21a9.003 9.003 0 008.354-5.646z" />
                        </svg>
                    </button>
                </div>
            </header>

            <main class="p-4 md:p-6 max-w-5xl mx-auto w-full">
        <h1 class="text-3xl font-semibold mb-6">Apartment Booking</h1>

        <!-- Stepper -->
        <!-- Stepper -->
        <div class="grid grid-cols-3 gap-2 mb-8">
            <div class="flex items-center justify-center md:justify-start gap-3">
                <div id="dot-1" class="h-8 w-8 rounded-full bg-accent text-white flex items-center justify-center font-bold shrink-0">1</div>
                <span class="text-sm hidden md:block">Allotment Letter</span>
            </div>
            <div class="flex items-center justify-center md:justify-start gap-3">
                <div id="dot-2" class="h-8 w-8 rounded-full bg-neutral-700 text-white flex items-center justify-center font-bold shrink-0">2</div>
                <span class="text-sm hidden md:block">Booking Form</span>
            </div>
            <div class="flex items-center justify-center md:justify-start gap-3">
                <div id="dot-3" class="h-8 w-8 rounded-full bg-neutral-700 text-white flex items-center justify-center font-bold shrink-0">3</div>
                <span class="text-sm hidden md:block">Declaration</span>
            </div>
        </div>

    <form action="{{ route('booking.submit') }}" method="POST" class="space-y-8" id="bookingForm" enctype="multipart/form-data">
            @csrf
            <!-- Step 1: Allotment Letter -->
            <section id="step-1" class="glass rounded-2xl p-6">
                <h2 class="text-2xl font-semibold mb-4 text-accent">1) Allotment Letter</h2>
                <div class="grid md:grid-cols-2 gap-4">
                    <div>
                        <label class="block text-sm mb-1">Reference No</label>
                        <input name="reference_no" type="text" class="w-full bg-white dark:bg-black/40 border border-gray-300 dark:border-neutral-700 rounded px-3 py-2 text-gray-900 dark:text-white" required>
                    </div>
                    <div>
                        <label class="block text-sm mb-1">Proposed Name</label>
                        <input name="proposed_name" type="text" class="w-full bg-white dark:bg-black/40 border border-gray-300 dark:border-neutral-700 rounded px-3 py-2 text-gray-900 dark:text-white" required>
                    </div>
                    <div>
                        <label class="block text-sm mb-1">S/O, W/O, D/O</label>
                        <input name="guardian" type="text" class="w-full bg-white dark:bg-black/40 border border-gray-300 dark:border-neutral-700 rounded px-3 py-2 text-gray-900 dark:text-white">
                    </div>
                    <div>
                        <label class="block text-sm mb-1">CNIC Number</label>
                        <input name="cnic" type="text" class="w-full bg-white dark:bg-black/40 border border-gray-300 dark:border-neutral-700 rounded px-3 py-2 text-gray-900 dark:text-white" placeholder="12345-1234567-1">
                    </div>
                    <div>
                        <label class="block text-sm mb-1">Gender</label>
                        <select name="gender" class="w-full bg-black/40 border border-neutral-700 rounded px-3 py-2">
                            <option>Male</option>
                            <option>Female</option>
                            <option>Other</option>
                        </select>
                    </div>
                    <div>
                        <label class="block text-sm mb-1">Apartment Number</label>
                        <input name="apartment_number" type="text" class="w-full bg-black/40 border border-neutral-700 rounded px-3 py-2" required>
                    </div>
                    <div>
                        <label class="block text-sm mb-1">Floor No</label>
                        <input name="floor_no" type="text" class="w-full bg-black/40 border border-neutral-700 rounded px-3 py-2">
                    </div>
                    <div>
                        <label class="block text-sm mb-1">Size</label>
                        <input name="size" type="text" class="w-full bg-black/40 border border-neutral-700 rounded px-3 py-2" placeholder="e.g., 1000 sq.ft">
                    </div>
                    <div class="md:col-span-2">
                        <label class="block text-sm mb-1">Category</label>
                        <input name="category" type="text" class="w-full bg-black/40 border border-neutral-700 rounded px-3 py-2">
                    </div>
                    <div class="md:col-span-2">
                        <label class="block text-sm mb-1">Postal Address</label>
                        <input name="address" type="text" class="w-full bg-black/40 border border-neutral-700 rounded px-3 py-2">
                    </div>
                    <div class="md:col-span-2">
                        <label class="block text-sm mb-1">Upload Photo</label>
                        <div class="file-upload w-full">
                            <label class="file-upload-label" id="allotmentLetterLabel">
                                <i class="fas fa-upload mr-2"></i>Choose File
                            </label>
                            <input type="file" name="allotment_letter" id="allotmentLetter" class="file-upload-input" accept="image/*,.pdf" required>
                            <div class="text-xs text-gray-400 mt-1" id="allotmentLetterName">No file chosen</div>
                            <img id="allotmentLetterPreview" class="image-preview" alt="Allotment Letter Preview">
                        </div>
                    </div>
                </div>
            </section>

            <!-- Step 2: Booking Form -->
            <section id="step-2" class="glass rounded-2xl p-6 step-hidden">
                <h2 class="text-2xl font-semibold mb-4 text-accent">2) Booking Form</h2>
                <div class="grid md:grid-cols-2 gap-4">
                    <div>
                        <label class="block text-sm mb-1">Application Form No</label>
                        <input name="application_no" type="text" class="w-full bg-white dark:bg-black/40 border border-gray-300 dark:border-neutral-700 rounded px-3 py-2 text-gray-900 dark:text-white">
                    </div>
                    <div>
                        <label class="block text-sm mb-1">Registration No</label>
                        <input name="registration_no" type="text" class="w-full bg-white dark:bg-black/40 border border-gray-300 dark:border-neutral-700 rounded px-3 py-2 text-gray-900 dark:text-white">
                    </div>
                    <div class="md:col-span-2">
                        <label class="block text-sm mb-1">Residential Address</label>
                        <input name="residential_address" type="text" class="w-full bg-white dark:bg-black/40 border border-gray-300 dark:border-neutral-700 rounded px-3 py-2 text-gray-900 dark:text-white">
                    </div>
                    <div>
                        <label class="block text-sm mb-1">Nationality</label>
                        <input name="nationality" type="text" class="w-full bg-white dark:bg-black/40 border border-gray-300 dark:border-neutral-700 rounded px-3 py-2 text-gray-900 dark:text-white">
                    </div>
                    <div>
                        <label class="block text-sm mb-1">Age</label>
                        <input name="age" type="number" class="w-full bg-white dark:bg-black/40 border border-gray-300 dark:border-neutral-700 rounded px-3 py-2 text-gray-900 dark:text-white">
                    </div>
                    <div>
                        <label class="block text-sm mb-1">Marital Status</label>
                        <input name="marital_status" type="text" class="w-full bg-white dark:bg-black/40 border border-gray-300 dark:border-neutral-700 rounded px-3 py-2 text-gray-900 dark:text-white">
                    </div>
                    <div>
                        <label class="block text-sm mb-1">Alternate Contact Person</label>
                        <input name="alternate_person" type="text" class="w-full bg-white dark:bg-black/40 border border-gray-300 dark:border-neutral-700 rounded px-3 py-2 text-gray-900 dark:text-white">
                    </div>
                    <div class="md:col-span-2">
                        <label class="block text-sm mb-1">Notes</label>
                        <textarea name="notes" class="w-full bg-white dark:bg-black/40 border border-gray-300 dark:border-neutral-700 rounded px-3 py-2 text-gray-900 dark:text-white" rows="4" placeholder="Any additional information"></textarea>
                    </div>
                    <div class="md:col-span-2">
                        <p class="text-sm text-gray-300 mb-2">
                            I agree to pay installments regularly and dues, and abide by all the existing rules and regulations and those which may be prescribed by the Developer from time to time.
                        </p>
                    </div>
                    <div class="md:col-span-2 grid md:grid-cols-2 gap-4">
                        <div>
                            <label class="block text-sm mb-1">Cash / Cheques / PO No.</label>
                            <input name="payment_reference" type="text" class="w-full bg-white dark:bg-black/40 border border-gray-300 dark:border-neutral-700 rounded px-3 py-2 text-gray-900 dark:text-white">
                        </div>
                        <div>
                            <label class="block text-sm mb-1">Amount (Rs.)</label>
                            <input name="payment_amount" type="number" step="0.01" class="w-full bg-white dark:bg-black/40 border border-gray-300 dark:border-neutral-700 rounded px-3 py-2 text-gray-900 dark:text-white">
                        </div>
                        <div>
                            <label class="block text-sm mb-1">Payment Date</label>
                            <input name="payment_date" type="date" class="w-full bg-white dark:bg-black/40 border border-gray-300 dark:border-neutral-700 rounded px-3 py-2 text-gray-900 dark:text-white">
                        </div>
                        <div>
                            <label class="block text-sm mb-1">Drawn Bank</label>
                            <input name="payment_bank" type="text" class="w-full bg-white dark:bg-black/40 border border-gray-300 dark:border-neutral-700 rounded px-3 py-2 text-gray-900 dark:text-white">
                        </div>
                    </div>
                    <div class="md:col-span-2 grid md:grid-cols-2 gap-4">
                        <div>
                            <label class="block text-sm mb-1">Date</label>
                            <input name="agreement_date" type="date" class="w-full bg-white dark:bg-black/40 border border-gray-300 dark:border-neutral-700 rounded px-3 py-2 text-gray-900 dark:text-white">
                        </div>
                        <div>
                            <label class="block text-sm mb-1">Signature of Applicant</label>
                            <div class="border border-gray-300 dark:border-neutral-700 rounded bg-white dark:bg-black/40 flex flex-col items-stretch">
                                <canvas id="signaturePad" class="w-full h-40 bg-gray-50 dark:bg-black/20 rounded-t"></canvas>
                                <div class="flex justify-between items-center px-2 py-1 text-xs text-gray-400">
                                    <span>Draw your signature here</span>
                                    <button type="button" id="clearSignature" class="px-3 py-1 border border-neutral-600 rounded">Clear</button>
                                </div>
                            </div>
                            <input type="hidden" name="applicant_signature" id="applicantSignatureInput">
                        </div>
                    </div>
                    <div class="md:col-span-2">
                        <label class="block text-sm mb-1">Upload Photo</label>
                        <div class="file-upload w-full">
                            <label class="file-upload-label" id="bookingFormPhotoLabel">
                                <i class="fas fa-upload mr-2"></i>Choose File
                            </label>
                            <input type="file" name="booking_form_photo" id="bookingFormPhotoInput" class="file-upload-input" accept="image/*,.pdf">
                            <div class="text-xs text-gray-400 mt-1" id="bookingFormPhotoName">No file chosen</div>
                            <img id="bookingFormPhotoPreview" class="image-preview" alt="Booking Form Photo Preview">
                        </div>
                    </div>
                </div>
            </section>

            <!-- Step 3: Declaration by Applicant -->
            <section id="step-3" class="glass rounded-2xl p-6 step-hidden">
                <h2 class="text-2xl font-semibold mb-4 text-accent">3) Declaration by Applicant</h2>
                <div class="grid md:grid-cols-2 gap-4">
                    <div class="md:col-span-2">
                        <label class="block text-sm mb-1">Applicant Name</label>
                        <input name="applicant_name" type="text" class="w-full bg-white dark:bg-black/40 border border-gray-300 dark:border-neutral-700 rounded px-3 py-2 text-gray-900 dark:text-white" required>
                    </div>
                    <div class="md:col-span-2">
                        <label class="block text-sm mb-1">S/O, D/O</label>
                        <input name="applicant_guardian" type="text" class="w-full bg-white dark:bg-black/40 border border-gray-300 dark:border-neutral-700 rounded px-3 py-2 text-gray-900 dark:text-white">
                    </div>
                    <div class="md:col-span-2">
                        <label class="flex items-start gap-2 text-sm">
                            <input type="checkbox" class="h-4 w-4 mt-1 shrink-0" required>
                            <span>Hereby declare that I/we have read/understood the <span class="text-red-500 cursor-pointer hover:underline" onclick="openTermsModal()">terms and conditions</span> of booking/allocation of the project and accept the same, and further declare that I/we shall abide by all the existing rules, regulations, conditions, requirements, etc. or which may be prescribed and approved by the company, from time to time. I/we also undertake to make full payment of the price and other documentation and connection charges according to the payment schedule decided by the Company.</span>
                        </label>
                    </div>
                </div>
            </section>

            <!-- Navigation -->
            <div class="flex items-center justify-between">
                <button type="button" id="prevBtn" class="px-5 py-3 rounded-full border border-neutral-700 hover:border-white disabled:opacity-40">Back</button>
                <div class="flex gap-3">
                    <button type="button" id="nextBtn" class="px-6 py-3 rounded-full bg-accent hover-bg-accent text-white">Next</button>
                    <button type="submit" id="submitBtn" class="px-6 py-3 rounded-full bg-accent hover-bg-accent text-white step-hidden">Submit</button>
                </div>
            </div>
        </form>

    </main>
    </div>
    </div>
<script>
    function toggleSidebar() {
        const sidebar = document.getElementById('sidebar');
        const overlay = document.getElementById('sidebar-overlay');
        
        if (sidebar.classList.contains('-translate-x-full')) {
            // Open
            sidebar.classList.remove('-translate-x-full');
            overlay.classList.remove('hidden');
        } else {
            // Close
            sidebar.classList.add('-translate-x-full');
            overlay.classList.add('hidden');
        }
    }

    // File upload handling
    document.addEventListener('DOMContentLoaded', function() {
        // Allotment Letter upload
        const allotmentLetterInput = document.getElementById('allotmentLetter');
        const allotmentLetterLabel = document.getElementById('allotmentLetterLabel');
        const allotmentLetterName = document.getElementById('allotmentLetterName');
        const allotmentLetterPreview = document.getElementById('allotmentLetterPreview');

        allotmentLetterInput.addEventListener('change', function(e) {
            const file = e.target.files[0];
            if (file) {
                allotmentLetterName.textContent = file.name;
                if (file.type.startsWith('image/')) {
                    const reader = new FileReader();
                    reader.onload = function(e) {
                        allotmentLetterPreview.src = e.target.result;
                        allotmentLetterPreview.style.display = 'block';
                    }
                    reader.readAsDataURL(file);
                } else {
                    allotmentLetterPreview.style.display = 'none';
                }
            } else {
                allotmentLetterName.textContent = 'No file chosen';
                allotmentLetterPreview.style.display = 'none';
            }
        });

        // Booking Form upload
        const bookingFormPhotoInput = document.getElementById('bookingFormPhotoInput');
        const bookingFormPhotoLabel = document.getElementById('bookingFormPhotoLabel');
        const bookingFormPhotoName = document.getElementById('bookingFormPhotoName');
        const bookingFormPhotoPreview = document.getElementById('bookingFormPhotoPreview');

        if (bookingFormPhotoInput) {
            bookingFormPhotoInput.addEventListener('change', function(e) {
                const file = e.target.files[0];
                if (file) {
                    bookingFormPhotoName.textContent = file.name;
                    if (file.type.startsWith('image/')) {
                        const reader = new FileReader();
                        reader.onload = function(e) {
                            bookingFormPhotoPreview.src = e.target.result;
                            bookingFormPhotoPreview.style.display = 'block';
                        }
                        reader.readAsDataURL(file);
                    } else {
                        bookingFormPhotoPreview.style.display = 'none';
                    }
                } else {
                    bookingFormPhotoName.textContent = 'No file chosen';
                    bookingFormPhotoPreview.style.display = 'none';
                }
            });
        }

        const signatureCanvas = document.getElementById('signaturePad');
        const clearSignatureBtn = document.getElementById('clearSignature');

        if (signatureCanvas && signatureCanvas.getContext) {
            const signatureInput = document.getElementById('applicantSignatureInput');
            const ctx = signatureCanvas.getContext('2d');
            let drawing = false;
            let lastX = 0;
            let lastY = 0;

            function setCanvasSize() {
                const width = signatureCanvas.offsetWidth || 400;
                const height = signatureCanvas.offsetHeight || 160;
                signatureCanvas.width = width;
                signatureCanvas.height = height;
                ctx.lineWidth = 2;
                ctx.lineCap = 'round';
                if (document.documentElement.classList.contains('dark')) {
                    ctx.strokeStyle = '#ffffff';
                } else {
                    ctx.strokeStyle = '#000000';
                }
            }

            setCanvasSize();

            function getPos(e) {
                const rect = signatureCanvas.getBoundingClientRect();
                if (e.touches && e.touches.length > 0) {
                    return {
                        x: e.touches[0].clientX - rect.left,
                        y: e.touches[0].clientY - rect.top,
                    };
                }
                return {
                    x: e.clientX - rect.left,
                    y: e.clientY - rect.top,
                };
            }

            function startDraw(e) {
                e.preventDefault();
                drawing = true;
                
                // Update stroke style based on current theme
                if (document.documentElement.classList.contains('dark')) {
                    ctx.strokeStyle = '#ffffff';
                } else {
                    ctx.strokeStyle = '#000000';
                }

                const pos = getPos(e);
                lastX = pos.x;
                lastY = pos.y;
            }

            function draw(e) {
                if (!drawing) return;
                e.preventDefault();
                const pos = getPos(e);
                ctx.beginPath();
                ctx.moveTo(lastX, lastY);
                ctx.lineTo(pos.x, pos.y);
                ctx.stroke();
                lastX = pos.x;
                lastY = pos.y;
            }

            function endDraw(e) {
                if (!drawing) return;
                e.preventDefault();
                drawing = false;
                if (signatureInput) {
                    signatureInput.value = signatureCanvas.toDataURL('image/png');
                }
            }

            signatureCanvas.addEventListener('mousedown', startDraw);
            signatureCanvas.addEventListener('mousemove', draw);
            window.addEventListener('mouseup', endDraw);

            signatureCanvas.addEventListener('touchstart', startDraw, { passive: false });
            signatureCanvas.addEventListener('touchmove', draw, { passive: false });
            window.addEventListener('touchend', endDraw, { passive: false });

            if (clearSignatureBtn) {
                clearSignatureBtn.addEventListener('click', function() {
                    ctx.clearRect(0, 0, signatureCanvas.width, signatureCanvas.height);
                    if (signatureInput) {
                        signatureInput.value = '';
                    }
                });
            }

            window.addEventListener('resize', setCanvasSize);
        }
    });
</script>
    <script>
        const steps = [document.getElementById('step-1'), document.getElementById('step-2'), document.getElementById('step-3')];
        const dots = [document.getElementById('dot-1'), document.getElementById('dot-2'), document.getElementById('dot-3')];
        const prevBtn = document.getElementById('prevBtn');
        const nextBtn = document.getElementById('nextBtn');
        const submitBtn = document.getElementById('submitBtn');
        let current = 0;

        function render() {
            steps.forEach((s, i) => s.classList.toggle('step-hidden', i !== current));
            dots.forEach((d, i) => d.className = 'h-8 w-8 rounded-full flex items-center justify-center font-bold shrink-0 ' + (i <= current ? 'bg-accent text-white' : 'bg-neutral-700 text-white'));
            prevBtn.disabled = current === 0;
            nextBtn.classList.toggle('step-hidden', current === steps.length - 1);
            submitBtn.classList.toggle('step-hidden', current !== steps.length - 1);
        }
        prevBtn.addEventListener('click', () => { if (current > 0) { current--; render(); } });
        nextBtn.addEventListener('click', () => { if (current < steps.length - 1) { current++; render(); } });
        render();
    </script>
    <script type="module">
    import { supabase } from '/js/auth.js';

    const form = document.getElementById('bookingForm');

    function isCanvasBlank(canvas) {
        const ctx = canvas.getContext('2d');
        const pixelBuffer = new Uint32Array(
            ctx.getImageData(0, 0, canvas.width, canvas.height).data.buffer
        );
        return !pixelBuffer.some(color => color !== 0);
    }

    form.addEventListener('submit', async (e) => {
        e.preventDefault();

        const signatureCanvas = document.getElementById('signaturePad');
        const signatureInput = document.getElementById('applicantSignatureInput');
        if (signatureCanvas && signatureInput && signatureCanvas.getContext) {
            if (!isCanvasBlank(signatureCanvas)) {
                signatureInput.value = signatureCanvas.toDataURL('image/png');
            } else {
                signatureInput.value = '';
            }
        }

        const submitBtn = document.getElementById('submitBtn');
        submitBtn.disabled = true;
        submitBtn.textContent = 'Submitting...';

        try {
            const formData = new FormData(form);

            const { data: { user } } = await supabase.auth.getUser();
            if (!user) {
                alert('You must be logged in to submit a booking.');
                submitBtn.disabled = false;
                submitBtn.textContent = 'Submit';
                return;
            }

            // 1) Get the file from the input
            const file = formData.get('allotment_letter');
            if (!file || !file.name) {
                alert('Please choose a photo first.');
                submitBtn.disabled = false;
                submitBtn.textContent = 'Submit';
                return;
            }

            // 2) Upload to Supabase Storage (sanitize file name to avoid invalid key errors)
            const safeName = file.name.replace(/[^a-zA-Z0-9.\-_]/g, '_');
            const filePath = `allotments/${Date.now()}_${safeName}`;
            const { data: uploadData, error: uploadError } = await supabase.storage
                .from('allotments')      // bucket name
                .upload(filePath, file);

            if (uploadError) {
                console.error('Upload error:', uploadError);
                alert('Failed to upload image. Please try again.');
                submitBtn.disabled = false;
                submitBtn.textContent = 'Submit';
                return;
            }

            // 3) Get public URL
            const { data: publicData } = supabase
                .storage
                .from('allotments')
                .getPublicUrl(uploadData.path);

            const allotmentUrl = publicData.publicUrl;

            // 3b) Optional: upload booking form photo and get its public URL
            const bookingPhotoFile = formData.get('booking_form_photo');
            let bookingPhotoUrl = null;
            if (bookingPhotoFile && bookingPhotoFile.name) {
                const safeBookingName = bookingPhotoFile.name.replace(/[^a-zA-Z0-9.\-_]/g, '_');
                const bookingFilePath = `booking_forms/${Date.now()}_${safeBookingName}`;
                const { data: bookingUploadData, error: bookingUploadError } = await supabase.storage
                    .from('allotments')
                    .upload(bookingFilePath, bookingPhotoFile);

                if (bookingUploadError) {
                    console.error('Booking photo upload error:', bookingUploadError);
                    alert('Failed to upload booking photo. Please try again.');
                    submitBtn.disabled = false;
                    submitBtn.textContent = 'Submit';
                    return;
                }

                const { data: bookingPublicData } = supabase
                    .storage
                    .from('allotments')
                    .getPublicUrl(bookingUploadData.path);

                bookingPhotoUrl = bookingPublicData.publicUrl;
            }

            // 4) Insert booking row with allotment_url
            const { error: insertError } = await supabase
                .from('bookings')
                .insert({
                    user_id: user.id,
                    reference_no: formData.get('reference_no'),
                    proposed_name: formData.get('proposed_name'),
                    guardian: formData.get('guardian'),
                    cnic: formData.get('cnic'),
                    gender: formData.get('gender'),
                    apartment_number: formData.get('apartment_number'),
                    floor_no: formData.get('floor_no'),
                    size: formData.get('size'),
                    category: formData.get('category'),
                    address: formData.get('address'),
                    application_no: formData.get('application_no'),
                    registration_no: formData.get('registration_no'),
                    apartment_no_booking: formData.get('apartment_number'),
                    floor_booking: formData.get('floor_no'),
                    proposed_name_booking: formData.get('proposed_name'),
                    guardian_booking: formData.get('guardian'),
                    postal_address_booking: formData.get('address'),
                    cnic_booking: formData.get('cnic'),
                    relation_booking: formData.get('relation_booking'),
                    phone_no_booking: formData.get('phone_no_booking'),
                    residential_address: formData.get('residential_address'),
                    nationality: formData.get('nationality'),
                    age: formData.get('age'),
                    marital_status: formData.get('marital_status'),
                    alternate_person: formData.get('alternate_person'),
                    notes: formData.get('notes'),
                    applicant_name: formData.get('applicant_name'),
                    applicant_guardian: formData.get('applicant_guardian'),
                    applicant_signature: formData.get('applicant_signature'),
                    payment_reference: formData.get('payment_reference'),
                    payment_amount: formData.get('payment_amount'),
                    payment_date: formData.get('payment_date'),
                    payment_bank: formData.get('payment_bank'),
                    agreement_date: formData.get('agreement_date'),
                    allotment_url: allotmentUrl,
                    // document_url: bookingPhotoUrl,
                    status: 'pending',
                    is_approved: false,
                });

            if (insertError) {
                console.error('Insert error:', insertError);
                alert('Failed to save booking. Please try again.');
                submitBtn.disabled = false;
                submitBtn.textContent = 'Submit';
                return;
            }

            alert('Booking submitted successfully!');
            // Optional: redirect to success page
            window.location.href = '/booking';
        } catch (err) {
            console.error('Unexpected error:', err);
            alert('Something went wrong. Please try again.');
            submitBtn.disabled = false;
            submitBtn.textContent = 'Submit';
        }
    });
</script>
    <!-- Terms Modal -->
    <div id="termsModal" class="fixed inset-0 bg-black/80 z-50 hidden flex items-center justify-center p-4">
        <div class="bg-neutral-900 border border-neutral-700 rounded-2xl w-full max-w-2xl max-h-[80vh] flex flex-col">
            <div class="p-6 border-b border-neutral-800 flex justify-between items-center">
                <h3 class="text-xl font-semibold text-white">Terms and Conditions</h3>
                <button type="button" onclick="closeTermsModal()" class="text-gray-400 hover:text-white">
                    <svg xmlns="http://www.w3.org/2000/svg" class="h-6 w-6" fill="none" viewBox="0 0 24 24" stroke="currentColor">
                        <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M6 18L18 6M6 6l12 12" />
                    </svg>
                </button>
            </div>
            <div class="p-6 overflow-y-auto text-gray-300 text-sm space-y-6 leading-relaxed">
                <div>
                    <h4 class="text-accent font-bold text-base mb-2">NAME OF THE PROJECT</h4>
                    <p>Name of the Project shall be 'The ONYX' by MEER ONYX DEVELOPMENTS (Pvt.) Ltd., which is being built/constructed in Kuza Gali Galiyat KPK, Pakistan. The company "MOD" shall construct a luxury residential project 'The ONYX', where apartments and penthouses are offered for sale on an ownership basis.</p>
                </div>

                <div>
                    <h4 class="text-accent font-bold text-base mb-2">BOOKING</h4>
                    <p>All Pakistani citizens and non-resident Pakistanis living abroad are eligible to apply for the offered inventory.</p>
                </div>

                <div>
                    <h4 class="text-accent font-bold text-base mb-2">ALLOCATION</h4>
                    <p>Allocation of a particular number of apartment units in the project is provisional and will be confirmed only after receiving full and final payment. If any allottee has booked a unit (provisional) and paid the booking amount, as it is a mandatory requirement, and later on if he/she fails to pay confirmation and/or allocation amounts as prescribed in the payment schedule, signed by the allottee, the booking amount shall be non-refundable.</p>
                </div>

                <div>
                    <h4 class="text-accent font-bold text-base mb-2">BOOKING & PAYMENT PROCEDURE</h4>
                    <p class="mb-3">All applications for booking/allotment shall be submitted on the prescribed form, duly filled in and signed by the applicant. The schedule fixed for each and every installment for the payments shall be the essence of the contract. All payments shall be made by the Allottee/Purchaser of the apartment via pay order, Cross cheques only drawn in the name of MEER ONYX DEVELOPMENTS (Pvt.) Ltd.</p>
                    <p>The applicant shall make the payment of installments by the 10th of every month (if the payment schedule is on a monthly basis). If he/she fails to pay on time, a late payment surcharge of 0.05% per day will be levied on the outstanding amount.</p>
                </div>

                <div>
                    <h4 class="text-accent font-bold text-base mb-2">SURRENDER OF APARTMENTS/UNIT</h4>
                    <p class="mb-3">In case of failure to pay the installment, demand notice of fifteen (15) day shall be served to the buyer by registered post/acknowledgement due or urgent mail service and/or TCS or renowned courier service. Another reminder will follow this after thirty (30) days for the payment of the installment at the address provided in the application form.</p>
                    <p class="mb-3">If the payment is not received within the stipulated period, the Company shall serve a final notice and cancel the booking/allotment/allocation. The amount received by MEER ONYX DEVELOPMENTS (Pvt.) Ltd. till that time shall be refunded after twelve (12) months after the completion of the project. An amount equal to 15% of the total price of the apartment shall be deducted from the refundable amount as service and establishment charges.</p>
                    <p>In case an Applicant subsequently wishes to surrender his/her Apartment or it stands cancelled, the amount will be refunded after completion of this project, subject to rebooking and deduction of 15% of the total agreed price of the apartment will be made from the installments deposited by the Applicant, being the service and establishment charges.</p>
                </div>

                <div>
                    <h4 class="text-accent font-bold text-base mb-2">ADDITIONAL TERMS</h4>
                    <ul class="space-y-2 list-disc list-inside">
                        <li>The cost of apartment as given in the payment schedule, does not include ground rent, registration fees, ownership transfer fee documentation charges, connection and meter charges of electricity, gas, water and sewerage and others, which shall be paid by the Allottee/Purchaser in CASH to the Company within fifteen (15) days on demand and in no circumstances refundable.</li>
                        <li>Prior to taking over the physical possession of the allotted unit, a six (6) months advance expense on account of maintenance charges i.e., service utilities, salaries of care takers, watchman (chowkidars), plumbers, electricians, air-condition maintenance etc. and also other administrative overhead charges will be payable by the Allottee on demand.</li>
                        <li>The Allottee shall form a registered association before the end of the maintenance period managed by the Company; otherwise, the Company will not be responsible after the end of the maintenance period regarding common and general services and proper upkeep/cleanliness of the project.</li>
                        <li>In case of a change of address, the Allottee shall inform the Company in writing about the change within fifteen (15) days.</li>
                        <li>The allotment shall be liable to cancellation in case monthly installments are not paid for three (3) months continuously (whether formally demanded or not).</li>
                        <li>There shall be no unilateral escalation towards the basic cost of the unit, and the Company undertakes to deliver the possession within the stipulated time, except due to unavoidable circumstances beyond the control of the company.</li>
                    </ul>
                </div>

                <div>
                    <h4 class="text-accent font-bold text-base mb-2">CHANGE IN THE NAME AND PLANS</h4>
                    <p class="mb-3">The Company reserves the right to seek a change of the project's Name, at any stage, for whatsoever reason, which shall be notified to the Allotee(s) by the Company, and can also make any change in the building plans of the project.</p>
                    <p>The Company retains and reserves the right at all times to make any changes in designs and specifications at the sole discretion of the Company. Management can change the location of the apartments due to any technical reasons. If the area of any apartment changes to the actual size, then it will be charged at the price per sq. ft. Area.</p>
                </div>

                <div>
                    <h4 class="text-accent font-bold text-base mb-2">TRANSFER</h4>
                    <p>The Allottee shall not sublet, sell, transfer, or assign the unit prior to taking over possession of the same, subject to written consent of the Company/Promoter/Builder. However, the apartment can be transferred after clearance of outstanding dues payable before or on the date of transfer. The Company will charge a Transfer Fee at the time of transfer of the apartment.</p>
                </div>

                <div>
                    <h4 class="text-accent font-bold text-base mb-2">UTILITY SERVICES BY UTILITY DEPARTMENTS</h4>
                    <p class="mb-3">The Company will arrange for water lines to all the underground water tanks of the project in case the water supply is not received or disrupted. The Company shall have no responsibility, and no Allottee will have any claim against the Company, nor shall the Company be approached by the Allottees in this connection.</p>
                    <p>The Company shall not be responsible for any delay in respect of the supply or individual connection of gas, electricity, water, sewerage, etc. by the concerned authorities/agencies. The Allottee shall be responsible for the payments of utility, i.e., water, sewerage, electricity, gas, telephones, etc., and property and other taxes of concerned authorities/agencies.</p>
                </div>

                <div>
                    <h4 class="text-accent font-bold text-base mb-2">POSSESSION</h4>
                    <p>The Allottees must take over possession of the booked units of the project within fifteen (15) days of the issuance of the stipulated period. The Company shall not be responsible for the maintenance or damages to the property, including theft and damages to the fittings of the bathrooms, kitchen, doors, windows, electricity or gas fittings, or any kind of Internal or external parts of the property.</p>
                </div>

                <div>
                    <h4 class="text-accent font-bold text-base mb-2">COMPLETION</h4>
                    <p>The construction of the project is supposed to be completed within the specified period. However, if for reasons of force majeure, which includes Act of God, riots, war (declared or undeclared), civil commotion, natural disaster, hostilities, fire, flood, legal construction bans, uncontrolled inflation (beyond 8%), earthquake, explosions, blockades and any other calamities which are beyond the Control of the Company, the builder shall be at liberty to revise/interrupt the construction schedule.</p>
                </div>

                <div>
                    <h4 class="text-accent font-bold text-base mb-2">THE APPLICANT AGREES</h4>
                    <ul class="space-y-2 list-disc list-inside">
                        <li>To maintain the apartment on his/her own cost in good condition and shall not do any act of endangers, damages, or impairs the building and the common area of the MEER ONYX DEVELOPMENTS (Pvt.) Ltd.</li>
                        <li>Not to bring inside the project or apartment of the project any goods and/or machinery which are hazardous/combustible, or flammable.</li>
                        <li>To pay all taxes, etc., levied by the Federal Government, Local bodies and Municipal bodies, and/or any other authorities/agencies.</li>
                        <li>Not to make any partitions, alterations, additions, or any holes, attachments, or adhesions of any nature without the consent of the Company.</li>
                        <li>Not to demand any extra work to be carried out by the Company on request of the Applicant under any circumstances during the construction/finishing of the project.</li>
                        <li>Not to misuse the amenities provided by the Company, nor will they cover/encroach on the areas or lobbies.</li>
                        <li>To use the unit for the purpose as specified and approved by the Company.</li>
                        <li>Maintenance charges are not included in the actual amount, will be charged on a monthly basis.</li>
                        <li>The rights of the roof shall be retained by the Company at all times, and units' Occupants/applicants will have no share, claim, or interest in and over the roof of the top floor.</li>
                    </ul>
                </div>

                <div>
                    <h4 class="text-accent font-bold text-base mb-2">ABANDONMENT OF THE PROJECT</h4>
                    <p>That if, for any reason, the project is abandoned, Company shall refund the amount received from the Allottee within the earliest convenience of the Company. It is, however, clearly understood that in such an eventuality, the Allottees shall not be entitled to any claim as damages, interests or profits, etc. of whatever nature.</p>
                </div>
            </div>
            <div class="p-6 border-t border-neutral-800 flex justify-end">
                <button type="button" onclick="closeTermsModal()" class="px-6 py-2 rounded-full bg-accent text-white">Close</button>
            </div>
        </div>
    </div>
    <script>
        function openTermsModal() {
            document.getElementById('termsModal').classList.remove('hidden');
        }
        function closeTermsModal() {
            document.getElementById('termsModal').classList.add('hidden');
        }
        // Close modal when clicking outside
        document.getElementById('termsModal').addEventListener('click', function(e) {
            if (e.target === this) {
                closeTermsModal();
            }
        });
    </script>
</body>
</html>


