<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Support - The ONYX</title>
    <script src="https://cdn.tailwindcss.com"></script>
    <style>
        .bg-accent { background: linear-gradient(to right, #22696B, #0C4C4C); }
        body { background-color:#0a0a0a; color:#fff; font-family: ui-sans-serif, system-ui, -apple-system, Segoe UI, Roboto, Helvetica, Arial; }
        .glass { background: rgba(255,255,255,0.04); border: 1px solid rgba(255,255,255,0.08); backdrop-filter: blur(6px); }
    </style>
</head>
<body>
    <header class="text-white px-6 py-4 flex items-center justify-between" style="background: linear-gradient(to right, #22696B, #0C4C4C);">
        <div>
            <h1 class="text-xl font-semibold">Support Center</h1>
            <p class="text-sm text-white/80">Need help? Reach the ONYX support team</p>
        </div>
        <nav class="text-sm space-x-4">
            <a href="{{ route('dashboard') }}" class="underline">Dashboard</a>
            <a href="{{ route('admin.dashboard') }}" class="underline">Admin</a>
        </nav>
    </header>

    <main class="max-w-4xl mx-auto px-6 py-10 space-y-6">
        <section class="glass rounded-xl p-6">
            <h2 class="text-lg font-semibold mb-4">Contact Options</h2>
            <div class="grid md:grid-cols-3 gap-4">
                <div class="border border-neutral-800 rounded-xl p-4">
                    <div class="text-sm text-gray-400">Email</div>
                    <div class="text-lg font-medium mt-2">infopk@meer.capital</div>
                </div>
                <div class="border border-neutral-800 rounded-xl p-4">
                    <div class="text-sm text-gray-400">Phone</div>
                    <div class="text-lg font-medium mt-2">+92 310 333 8442</div>
                </div>
                <div class="border border-neutral-800 rounded-xl p-4">
                    <div class="text-sm text-gray-400">Office</div>
                    <div class="text-lg font-medium mt-2">Rizwan Plaza, Blue Area</div>
                </div>
            </div>
        </section>

        <section class="glass rounded-xl p-6">
            <h2 class="text-lg font-semibold mb-4">Submit a Ticket</h2>
            <form class="space-y-4">
                <div>
                    <label class="block text-sm text-gray-300 mb-1">Name</label>
                    <input type="text" class="w-full bg-black/40 border border-neutral-700 rounded px-3 py-2">
                </div>
                <div class="grid md:grid-cols-2 gap-4">
                    <div>
                        <label class="block text-sm text-gray-300 mb-1">Email</label>
                        <input type="email" class="w-full bg-black/40 border border-neutral-700 rounded px-3 py-2">
                    </div>
                    <div>
                        <label class="block text-sm text-gray-300 mb-1">Topic</label>
                        <select class="w-full bg-black/40 border border-neutral-700 rounded px-3 py-2">
                            <option>Booking</option>
                            <option>Payment</option>
                            <option>Asset Information</option>
                            <option>General Inquiry</option>
                        </select>
                    </div>
                </div>
                <div>
                    <label class="block text-sm text-gray-300 mb-1">Message</label>
                    <textarea rows="4" class="w-full bg-black/40 border border-neutral-700 rounded px-3 py-2"></textarea>
                </div>
                <button type="button" class="px-6 py-3 rounded-full bg-accent text-white">Send</button>
            </form>
        </section>
    </main>
</body>
</html>


