<?php

use Illuminate\Support\Facades\Route;

// Home route
Route::get('/', function () {
    return view('register');
})->name('home');

// Login routes (closure-based: controllers not present)
Route::get('/login', function () {
    return view('login');
})->name('login');
Route::post('/login', function (\Illuminate\Http\Request $request) {
    // Placeholder auth handling
    return redirect()->route('login');
});

// Register routes (closure-based placeholder)
Route::get('/register', function () {
    return view('register');
})->name('register');
Route::post('/register', function (\Illuminate\Http\Request $request) {
    // Placeholder register handling
    return redirect()->route('login');
});

// Admin login routes
Route::get('/admin/login', function () {
    return view('admin_login');
})->name('admin.login');

Route::post('/admin/login', function (\Illuminate\Http\Request $request) {
    // Placeholder admin auth
    return redirect()->route('admin.dashboard');
})->name('admin.login.submit');

Route::get('/admin/approvals', function () {
    return view('admin_approvals');
})->name('admin.approvals');

// Password reset routes (placeholder views)
Route::get('/password/reset', function () {
    return response('<html><body style="font-family: ui-sans-serif, system-ui; padding:24px"><h1>Password Reset</h1><p>Please contact support to reset your password.</p><p><a href="/" style="color:#f57c00">Back to Home</a></p></body></html>');
})->name('password.request');
Route::post('/password/email', function () {
    return redirect()->route('password.request');
})->name('password.email');

// Booking form routes
Route::get('/booking', function () {
    return view('form');
})->name('booking.form');

Route::post('/booking', function (\Illuminate\Http\Request $request) {
    // For now, just display a success page. You can persist to DB later.
    return view('booking_success', [
        'name' => $request->input('proposed_name') ?? $request->input('applicant_name'),
        'apartment' => $request->input('apartment_number'),
    ]);
})->name('booking.submit');

// Dashboard + Assets
Route::get('/dashboard', function () {
    return view('dashboard');
})->name('dashboard');

Route::get('/my-bookings', function () {
    return view('user_bookings');
})->name('user.bookings');

Route::get('/my-documents', function () {
    return view('user_bookings');
})->name('user.documents');

Route::get('/admin/dashboard', function () {
    return view('admin_dashboard');
})->name('admin.dashboard');

Route::get('/reports', function () {
    return view('reports');
})->name('reports');

Route::get('/support', function () {
    return view('support');
})->name('support');

Route::get('/admin/users', function () {
    return view('admin_users');
})->name('admin.users');

Route::get('/admin/settings', function () {
    return view('admin_settings');
})->name('admin.settings');
