<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Assets - The ONYX</title>
    <script src="https://cdn.tailwindcss.com"></script>
    <style>
        .bg-accent { background-color: #f57c00; }
        body { background-color:#0a0a0a; color:#fff; font-family: ui-sans-serif, system-ui, -apple-system, Segoe UI, Roboto, Helvetica, Arial; }
        .glass { background: rgba(255,255,255,0.03); border: 1px solid rgba(255,255,255,0.08); backdrop-filter: blur(6px); }
    </style>
</head>
<body data-require-auth="true" data-require-role="client">
    <header class="bg-accent text-white px-6 py-4 flex items-center justify-between">
        <div class="font-semibold">Assets</div>
        <nav class="text-sm space-x-4">
            <a href="<?php echo e(route('dashboard')); ?>" class="underline">Dashboard</a>
            <a href="<?php echo e(route('booking.form')); ?>" class="underline">Booking</a>
        </nav>
    </header>
    <main class="max-w-6xl mx-auto p-6">
        <div class="glass rounded-xl overflow-hidden">
            <table class="w-full text-left">
                <thead class="bg-black/40">
                    <tr>
                        <th class="px-4 py-3">Asset</th>
                        <th class="px-4 py-3">Type</th>
                        <th class="px-4 py-3">Status</th>
                        <th class="px-4 py-3">Actions</th>
                    </tr>
                </thead>
                <tbody>
                    <tr class="border-t border-neutral-800">
                        <td class="px-4 py-3">Apartment A-101</td>
                        <td class="px-4 py-3 text-gray-300">2 Bed</td>
                        <td class="px-4 py-3"><span class="px-2 py-1 rounded bg-yellow-500/20 text-yellow-400 text-xs">Reserved</span></td>
                        <td class="px-4 py-3"><a href="<?php echo e(route('booking.form')); ?>" class="underline">View</a></td>
                    </tr>
                    <tr class="border-t border-neutral-800">
                        <td class="px-4 py-3">Apartment B-305</td>
                        <td class="px-4 py-3 text-gray-300">1 Bed</td>
                        <td class="px-4 py-3"><span class="px-2 py-1 rounded bg-green-500/20 text-green-400 text-xs">Available</span></td>
                        <td class="px-4 py-3"><a href="<?php echo e(route('booking.form')); ?>" class="underline">Book</a></td>
                    </tr>
                    <tr class="border-t border-neutral-800">
                        <td class="px-4 py-3">Penthouse P-1</td>
                        <td class="px-4 py-3 text-gray-300">Penthouse</td>
                        <td class="px-4 py-3"><span class="px-2 py-1 rounded bg-red-500/20 text-red-400 text-xs">Sold</span></td>
                        <td class="px-4 py-3"><span class="text-gray-500">—</span></td>
                    </tr>
                </tbody>
            </table>
        </div>
    </main>
</body>
<script type="module" src="/js/auth.js"></script>
</html>


<?php /**PATH /Users/apple/Documents/onyx/resources/views/assets.blade.php ENDPATH**/ ?>