<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Admin Users - The ONYX</title>
    <script src="https://cdn.tailwindcss.com"></script>
    <script>
        tailwind.config = {
            darkMode: 'class',
        }
    </script>
    <style>
        .bg-accent { background: linear-gradient(to right, #22696B, #0C4C4C); }
        .text-accent { color: #22696B; }
        body { font-family: ui-sans-serif, system-ui, -apple-system, Segoe UI, Roboto, Helvetica, Arial; }
        .glass { background: rgba(255,255,255,0.03); border: 1px solid rgba(255,255,255,0.08); backdrop-filter: blur(8px); }
        .dark .glass { background: rgba(255,255,255,0.03); border: 1px solid rgba(255,255,255,0.08); }
        .light .glass { background: rgba(255,255,255,0.7); border: 1px solid rgba(0,0,0,0.1); }
        .sidebar { min-width: 260px; }
        .nav-link { display:block; padding:0.75rem 1rem; border-radius:0.75rem; transition: all .2s ease; }
        .dark .nav-link { color:#cfcfcf; }
        .light .nav-link { color:#4b5563; }
        .nav-link:hover, .nav-link.active { background-color: rgba(245,124,0,0.15); color:#fff; }
        .light .nav-link:hover, .light .nav-link.active { background-color: rgba(34, 105, 107, 0.1); color:#22696B; }
    </style>
    <script>
        // Check local storage or system preference
        if (localStorage.theme === 'dark' || (!('theme' in localStorage) && window.matchMedia('(prefers-color-scheme: dark)').matches)) {
            document.documentElement.classList.add('dark');
            document.documentElement.classList.remove('light');
        } else {
            document.documentElement.classList.remove('dark');
            document.documentElement.classList.add('light');
            localStorage.theme = 'light'; // Set default to light if no preference and not dark
        }

        function toggleTheme() {
            if (document.documentElement.classList.contains('dark')) {
                document.documentElement.classList.remove('dark');
                document.documentElement.classList.add('light');
                localStorage.theme = 'light';
            } else {
                document.documentElement.classList.remove('light');
                document.documentElement.classList.add('dark');
                localStorage.theme = 'dark';
            }
        }
    </script>
</head>
<body data-require-auth="true" data-require-role="admin" class="bg-gray-50 text-gray-900 dark:bg-[#0a0a0a] dark:text-white transition-colors duration-300">
    <div class="min-h-screen flex relative">
        <!-- Mobile Sidebar Overlay -->
        <div id="sidebar-overlay" class="fixed inset-0 bg-black/80 z-40 hidden lg:hidden glass" onclick="toggleSidebar()"></div>

        <!-- Sidebar -->
        <aside id="sidebar" class="sidebar bg-white dark:bg-black/90 border-r border-gray-200 dark:border-neutral-800 p-6 fixed inset-y-0 left-0 z-50 w-64 transform -translate-x-full transition-transform duration-300 lg:translate-x-0 lg:static lg:flex flex-col">
            <div class="flex items-center justify-between mb-10">
                <div class="text-2xl font-extrabold tracking-wide">
                    <img src="/images/logo.png" alt="Onyx Admin Logo" class="h-12 block dark:hidden" style="filter: invert(1);">
                    <img src="/images/logo.png" alt="Onyx Admin Logo" class="h-12 hidden dark:block">
                </div>
                <button class="lg:hidden text-gray-400 hover:text-gray-900 dark:hover:text-white" onclick="toggleSidebar()">
                    <svg xmlns="http://www.w3.org/2000/svg" class="h-6 w-6" fill="none" viewBox="0 0 24 24" stroke="currentColor">
                        <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M6 18L18 6M6 6l12 12" />
                    </svg>
                </button>
            </div>
            <nav class="space-y-1 flex-1">
                <a href="<?php echo e(route('admin.dashboard')); ?>" class="nav-link">Dashboard</a>
                <a href="<?php echo e(route('admin.approvals')); ?>" class="nav-link">Approvals</a>
                <a href="<?php echo e(route('admin.users')); ?>" class="nav-link active">Users</a>
                <a href="<?php echo e(route('admin.settings')); ?>" class="nav-link">Settings</a>
                <a href="#" data-auth="logout" data-redirect="/login" class="nav-link">Logout</a>
            </nav>
            <div class="mt-6 glass rounded-xl p-4 bg-gray-100 dark:bg-transparent">
                <div class="text-xs uppercase text-gray-500 dark:text-gray-400">Support</div>
                <div class="text-sm mt-1 text-gray-900 dark:text-white">infopk@meer.capital</div>
            </div>
        </aside>

        <div class="flex-1 flex flex-col min-w-0">
            <header class="text-white px-4 md:px-6 py-4 flex items-center justify-between sticky top-0 z-30" style="background: linear-gradient(to right, #22696B, #0C4C4C);">
                <div class="flex items-center gap-3">
                    <button class="lg:hidden p-1 hover:bg-white/10 rounded" onclick="toggleSidebar()">
                        <svg xmlns="http://www.w3.org/2000/svg" class="h-6 w-6" fill="none" viewBox="0 0 24 24" stroke="currentColor">
                            <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M4 6h16M4 12h16M4 18h16" />
                        </svg>
                    </button>
                    <div>
                        <h1 class="text-lg md:text-xl font-semibold">User Management</h1>
                        <p class="text-xs md:text-sm text-white/80">Manage system users and permissions</p>
                    </div>
                </div>
                <div class="flex items-center gap-4">
                    <button onclick="toggleTheme()" class="p-2 rounded-full hover:bg-white/10 transition-colors">
                        <!-- Sun icon -->
                        <svg xmlns="http://www.w3.org/2000/svg" class="h-5 w-5 hidden dark:block" fill="none" viewBox="0 0 24 24" stroke="currentColor">
                            <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M12 3v1m0 16v1m9-9h-1M4 12H3m15.364 6.364l-.707-.707M6.343 6.343l-.707-.707m12.728 0l-.707.707M6.343 17.657l-.707.707M16 12a4 4 0 11-8 0 4 4 0 018 0z" />
                        </svg>
                        <!-- Moon icon -->
                        <svg xmlns="http://www.w3.org/2000/svg" class="h-5 w-5 block dark:hidden" fill="none" viewBox="0 0 24 24" stroke="currentColor">
                            <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M20.354 15.354A9 9 0 018.646 3.646 9.003 9.003 0 0012 21a9.003 9.003 0 008.354-5.646z" />
                        </svg>
                    </button>
                <div class="hidden md:flex items-center gap-4 text-sm">
                    <a href="<?php echo e(route('booking.form')); ?>" class="underline">New Booking</a>
                    <a href="<?php echo e(route('user.documents')); ?>" class="underline">Documents</a>
                    <div class="w-8 h-8 rounded-full bg-white/20 flex items-center justify-center">A</div>
                </div>
            </header>

            <main class="p-4 md:p-6">
                <section class="glass rounded-xl overflow-hidden">
                    <div class="p-6 flex items-center justify-between border-b border-gray-200 dark:border-neutral-800">
                        <h2 class="text-lg font-semibold">User Directory</h2>
                        <button class="px-5 py-2 rounded-full bg-accent hover-bg-accent text-white text-sm font-medium transition-colors">Add User</button>
                    </div>
                    <div class="overflow-x-auto">
                        <table class="w-full text-left text-sm min-w-[600px]">
                            <thead class="bg-gray-100 dark:bg-black/40 text-gray-700 dark:text-gray-300">
                                <tr>
                                    <th class="px-6 py-4 font-medium">Name</th>
                                    <th class="px-6 py-4 font-medium">Email</th>
                                    <th class="px-6 py-4 font-medium">Role</th>
                                    <th class="px-6 py-4 font-medium">Status</th>
                                    <th class="px-6 py-4 font-medium">Actions</th>
                                </tr>
                            </thead>
                            <tbody id="user-table-body">
                                <script type="module">
                                    import { fetchSupabaseUsers } from '/js/auth.js';
    
                                    document.addEventListener('DOMContentLoaded', async () => {
                                        console.log('Fetching Supabase users...');
                                        try {
                                            const users = await fetchSupabaseUsers();
                                            console.log('Users fetched:', users);
                                            const tbody = document.querySelector('#user-table-body');
                                            tbody.innerHTML = ''; // Clear existing static rows
    
                                            if (users.length === 0) {
                                                tbody.innerHTML = '<tr><td colspan="5" class="text-center py-8 text-gray-500 dark:text-gray-400">No users found.</td></tr>';
                                                return;
                                            }
    
                                            users.forEach(user => {
                                                const row = `
                                                    <tr class="border-b border-gray-200 dark:border-neutral-800 hover:bg-gray-50 dark:hover:bg-white/5 transition-colors">
                                                        <td class="px-6 py-4 text-gray-900 dark:text-white font-medium">${user.full_name || 'N/A'}</td>
                                                        <td class="px-6 py-4 text-gray-600 dark:text-gray-400">${user.email}</td>
                                                        <td class="px-6 py-4">
                                                            <span class="inline-flex items-center px-2.5 py-0.5 rounded-full text-xs font-medium ${user.role === 'admin' ? 'bg-purple-100 text-purple-800 dark:bg-purple-900/30 dark:text-purple-300' : 'bg-blue-100 text-blue-800 dark:bg-blue-900/30 dark:text-blue-300'}">
                                                                ${user.role || 'User'}
                                                            </span>
                                                        </td>
                                                        <td class="px-6 py-4">
                                                            <span class="inline-flex items-center px-2.5 py-0.5 rounded-full text-xs font-medium bg-green-100 text-green-800 dark:bg-green-900/30 dark:text-green-300">
                                                                Active
                                                            </span>
                                                        </td>
                                                        <td class="px-6 py-4">
                                                            <button class="text-gray-400 hover:text-gray-600 dark:hover:text-gray-300 transition-colors">
                                                                <svg xmlns="http://www.w3.org/2000/svg" class="h-5 w-5" viewBox="0 0 20 20" fill="currentColor">
                                                                    <path d="M10 6a2 2 0 110-4 2 2 0 010 4zM10 12a2 2 0 110-4 2 2 0 010 4zM10 18a2 2 0 110-4 2 2 0 010 4z" />
                                                                </svg>
                                                            </button>
                                                        </td>
                                                    </tr>
                                                `;
                                                tbody.insertAdjacentHTML('beforeend', row);
                                            });
                                        } catch (error) {
                                            console.error('Error fetching and rendering users:', error);
                                            const tbody = document.querySelector('#user-table-body');
                                            tbody.innerHTML = '<tr><td colspan="5" class="text-center py-4 text-red-400">Error loading users.</td></tr>';
                                        }
                                    });
                                </script>
                            </tbody>
                        </table>
                    </div>
                </section>
            </main>
        </div>
    </div>
</body>
<script type="module" src="/js/auth.js"></script>
<script>
    function toggleSidebar() {
        const sidebar = document.getElementById('sidebar');
        const overlay = document.getElementById('sidebar-overlay');
        
        if (sidebar.classList.contains('-translate-x-full')) {
            // Open
            sidebar.classList.remove('-translate-x-full');
            overlay.classList.remove('hidden');
        } else {
            // Close
            sidebar.classList.add('-translate-x-full');
            overlay.classList.add('hidden');
        }
    }
</script>
</html>
<?php /**PATH /Users/apple/Documents/onyx/resources/views/admin_users.blade.php ENDPATH**/ ?>